/*
 * @brief SCTimer/PWM (SCT) Two Channel PWM example
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "board.h"


/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/
#define match_green_OFF		(5000000)
#define match_green_ON      (4000000)
#define match_red_OFF      	(9000000)
#define match_red_ON       	(1000000)
#define delay               (10000000)

/*****************************************************************************
 * Private functions
 ****************************************************************************/

/*****************************************************************************
 * Public functions
 ****************************************************************************/

void SCT_Init(void)
{

	Chip_SCT_Init(LPC_SCT);			                   												// enable the SCT clock

	Chip_SCT_Config(LPC_SCT, SCT_CONFIG_32BIT_COUNTER |
                            SCT_CONFIG_AUTOLIMIT_L );										// unified timer and auto limit


	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, delay);									// match_cycle
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_1, match_green_OFF);			 	// match_green_OFF
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_2, match_green_ON);				// match_green_ON
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_3, match_red_OFF);					// match_red_OFF
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_4, match_red_ON);					// match_red_ON

	Chip_SCT_EventStateMask(LPC_SCT, 0, ENABLE_STATE0);					    				// event 0 happens in state 0
	Chip_SCT_EventControl(LPC_SCT, 0, (CHIP_SCT_EVENTCTRL_T) ( 	SCT_EVECTRL_MATCH0	|			// related to match_cycle
			 	 	 	 	 	 	 	 	 	 	 	 	 	 SCT_IOSEL_1 		|
																 SCT_IOCOND_LOW		|																			// IN_0 low
                                                                SCT_COMBMODE_AND  	|		// match AND IO condition
                                                                SCT_STATELD_1	    |			// STATEV is loaded into state
                                                                SCT_STATEEV_1	    ));		// new state is 1


	Chip_SCT_EventStateMask(LPC_SCT, 1, ENABLE_STATE0); 					    										// event 1 happens in state 0
	Chip_SCT_EventControl(LPC_SCT, 1, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH3 |
			 	 	 	 	 	 	 	 	 	 	 	 		SCT_IOSEL_1 	  |
                                                               SCT_COMBMODE_MATCH ));  	// match_red_OFF only condition


	Chip_SCT_EventStateMask(LPC_SCT, 2, ENABLE_STATE0); 					    										// event 2 happens in state 0
	Chip_SCT_EventControl(LPC_SCT, 2,  (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH4	|
			 	 	 	 	 	 	 	 	 	 	 	 	 	 SCT_IOSEL_1 		|
                                                                SCT_COMBMODE_MATCH	));	// match_red_ON only condition


	Chip_SCT_EventStateMask(LPC_SCT, 3, ENABLE_STATE1); 					    										// event 3 happens in state 1
	Chip_SCT_EventControl(LPC_SCT, 3, (CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH0	|			// related to match_cycle
																SCT_IOSEL_1 	  	|
                                                                SCT_IOCOND_HIGH	    |		// IN_0 high
                                                                SCT_COMBMODE_AND	|			// match AND IO condition
                                                                SCT_STATELD_1		|				// STATEV is loaded into state
                                                                SCT_STATEEV_0		));			// new state is 0


	Chip_SCT_EventStateMask(LPC_SCT, 4, ENABLE_STATE1); 					    										// event 4 happens in state 1
	Chip_SCT_EventControl(LPC_SCT, 4, (CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH2	|
																	SCT_IOSEL_1 	|
                                                                SCT_COMBMODE_MATCH   ));// match_green_ON only condition


	Chip_SCT_EventStateMask(LPC_SCT, 5, ENABLE_STATE1); 					    										// event 5 happens in state 1
	Chip_SCT_EventControl(LPC_SCT, 5, (CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH1	 |		// match_green_OFF only condition
																	SCT_IOSEL_1 	 |
                                                                SCT_COMBMODE_MATCH	 ));


	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_4,  (CHIP_SCT_EVENT_T)  (    SCT_EVT_0 |
                                                                       	SCT_EVT_3 |
                                                                       	SCT_EVT_5 )); 	// event 0, 3 and 5 set OUT4 (green LED)

	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_4, SCT_EVT_4);					      								// event 4 clear OUT4 (green LED)

	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_2, (CHIP_SCT_EVENT_T)  (  SCT_EVT_0 |
                                                                   	 SCT_EVT_1 |
                                                                   	 SCT_EVT_3 ));			// event 0, 1 and 3 set OUT2 (red LED)

	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_2, SCT_EVT_2);																// event 2 clear OUT2 (red LED)

	Chip_SCT_Output(LPC_SCT, 0x14 );     																									// default set OUT4 and OUT2

	Chip_SCT_ClearControl(LPC_SCT,SCT_CTRL_HALT_L);	   																		// unhalt it by clearing bit 2 of the CTRL register
}



int main(void)
{
	SystemCoreClockUpdate();
	Board_Init();


	Chip_Clock_EnablePeriphClock((CHIP_SYSCON_CLOCK_T) ( SYSCON_CLOCK_GPIO0	|    			// enable GPIO port 0 clock
																											SYSCON_CLOCK_GPIO1	| 	      // enable GPIO port 1 clock
																											SYSCON_CLOCK_IOCON	|         //enable IOCON clock
																											SYSCON_CLOCK_INPUTMUX	));			//enable MUX clock


	Chip_GPIO_SetPinDIR(LPC_GPIO, 0, 24, false); 																			//as an input


	Chip_IOCON_PinMuxSet(LPC_IOCON, 0, 24, 	IOCON_FUNC0 		  	|
                                        IOCON_I2C_SLEW		  	|
                                       	IOCON_DIGITAL_EN	  	|
                                       	IOCON_INPFILT_OFF	  	|
																						0x0 << 6			    |
																						0x0 << 9			    |
                                          	0x1 << 10			    );


	Chip_IOCON_PinMuxSet(LPC_IOCON, 1, 10, IOCON_FUNC3 | IOCON_MODE_INACT | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);		//SCT0_OUT4 = P1.10  (green LED)
	Chip_IOCON_PinMuxSet(LPC_IOCON, 0, 29, IOCON_FUNC2 | IOCON_MODE_INACT | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);		//SCT0_OUT2 = P0.29  (red LED)


    SCT_Init();                                          											// Initialize SCT0

    while (1)                                              										// loop forever
    {
    	__WFI();
    }
}
